using System;
using System.Collections.Generic;
using System.Text;

namespace AnonMethods
{
   class Program
   {
      delegate void MessagePrintDelegate(string msg);

      static void Main(string[] args)
      {
         // wywoanie metody nazwanej
         MessagePrintDelegate mpd = new MessagePrintDelegate(PrintMessage);
         LongRunningMethod(mpd);

         // metoda anonimowa
         MessagePrintDelegate mpd2 = delegate(string msg)
         {
            Console.WriteLine("[Anonimowa] {0}", msg);
         };
         LongRunningMethod(mpd2);

         // uycie zmiennej 'zewntrznej' w metodzie anonimowej
         string source = "Zewntrzna";
         MessagePrintDelegate mpd3 = delegate(string msg)
         {
            Console.WriteLine("[{0}] {1}", source, msg);
         };
         LongRunningMethod(mpd3);

         Console.ReadLine();
      }

      static void LongRunningMethod(MessagePrintDelegate mpd)
      {
         for (int i = 0; i < 99; i++)
         {
            if (i % 25 == 0)
            {
               mpd(string.Format("Wykonano {0}%", i));
            }
         }
      }

      static void PrintMessage(string msg)
      {
         Console.WriteLine("[PrintMessage] {0}", msg);
      }
   }
}
